<?php
    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreTabella extends VisualizzatoreComponente {
        private $classeTabelle;
        private $javascriptAssociato;
        
        function __construct($db) {
            parent::__construct($db);
            $this->classeTabelle = "";
        }

        function generaContenutoSezione($dati) {
            $tabella = parent::getDb()->leggiSingolaRiga("geec_tabelle",$dati["idElemento"]);
            $this->classeTabelle = ($tabella["ordinabile"]=="si") ? "table display responsive nowrap" : "table";
            $queryRigheTabelle = "SELECT * FROM geec_righeTabella WHERE idTabella={$tabella["id"]} ORDER BY posizione ASC";
            $risRighe = parent::getDb()->eseguiQueryLettura($queryRigheTabelle);
            echo"<div class=\"{$tabella["spazioOccupato"]}\">\n"
                    ."<div class=\"table-responsive\">\n"
                        ."<table id=\"tabella{$dati["idElemento"]}\" class=\"$this->classeTabelle\" width=\"100%\">\n";
                        $this->stampaIntestazioneTabella($tabella);
                        echo"<tbody>";
                        while($elemento = $risRighe->fetch_assoc()) {
                            $this->stampaRiga($elemento);
                        }
                        echo"</tbody>";
                    echo"</table>\n
                    <p class=\"small text-muted mt-3\">{$tabella["note"]}</p>
                    </div>
                </div>\n";
            // genera il javascript
            $this->generaJavascript($tabella);
        }
        
        function stampaIntestazioneTabella($tabella) {
            $elementiIntestazione = explode(",",$tabella["intestazione"]);
            $sfondo = ($tabella["sfondoIntestazione"]!="") ? $tabella["sfondoIntestazione"] : "";
            $coloreTesti = ($tabella["coloreTestiIntestazione"]!="") ? $tabella["coloreTestiIntestazione"] : "";
            if($tabella["intestazione"]!="") {
                echo"<thead>
                        <tr style=\"background:{$sfondo}; color:$coloreTesti; \">";
                        foreach($elementiIntestazione as $elemento) {
                            echo"<th>$elemento</th>";
                        }
                    echo"</tr>
                </thead>";
            }
        }
        
        function stampaRiga($riga) {
            $elementiRiga = explode(",",$riga["elementi"]);
            
            $sfondo = ($riga["coloreSfondo"]!="") ? $riga["coloreSfondo"] : "";
            $coloreTesti = ($riga["coloreTesti"]!="") ? $riga["coloreTesti"] : "";
            
            echo"<tr style=\"background:{$sfondo}; color:$coloreTesti; \">";
            foreach($elementiRiga as $elemento) {
                echo"<td>$elemento</td>";
            }
            echo"</tr>";
        }
        
        function generaJavascript($tabella) {
            if($tabella["ordinabile"]=="si") {
                $this->javascriptAssociato = "<script>
                    $(document).ready( function () {
                    $('#tabella{$tabella["id"]}').DataTable({
                      searching: false,
                      paging: false,
                      info: false,
                      responsive: true
                    });
                  } );
                </script>";
            }
            else {
                $this->javascriptAssociato = "";
            }
        }
        
        function getJavascriptAssociato() {
            return $this->javascriptAssociato;
        }
    }
